using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgRecentTransfusionsIssues
	/// </summary>
	public class DlgRecentTransfusionsIssues : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private BOL.Patient _patient;
		private ArrayList _issuedTransfusedUnits;
		//
		private gov.va.med.vbecs.GUI.controls.PatientDisplayPanel patientDisplayPanel2;
		private System.Windows.Forms.GroupBox grpTransfusionHistory;
		private System.Windows.Forms.ListView lvTransfusionHistory;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.ColumnHeader columnHeader6;
		private System.Windows.Forms.ColumnHeader columnHeader7;
		private System.Windows.Forms.ColumnHeader columnHeader8;
		private System.Windows.Forms.ColumnHeader columnHeader9;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picImage;
		private System.Windows.Forms.ColumnHeader columnHeader10;
		private System.Windows.Forms.Button btnClose;
		private System.Windows.Forms.Panel pnlPatientSelect;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private gov.va.med.vbecs.GUI.controls.PatientSelectTool patientSelectTool1;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.Panel pnlUnits;
		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgRecentTransfusionsIssues()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();
		}
		
		/// <summary>
		/// Constructor
		/// </summary>
		public DlgRecentTransfusionsIssues(BOL.Patient patient) : this()
		{
			this.Patient = patient;
			//
			GetIssuedTransfusedUnits();
			//
			this.pnlPatientSelect.Visible = false;
			this.pnlUnits.Visible = true;
			//
			this.LoadIssuedTransfusedUnits();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgRecentTransfusionsIssues));
			this.btnClose = new System.Windows.Forms.Button();
			this.patientDisplayPanel2 = new gov.va.med.vbecs.GUI.controls.PatientDisplayPanel();
			this.grpTransfusionHistory = new System.Windows.Forms.GroupBox();
			this.lvTransfusionHistory = new System.Windows.Forms.ListView();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader3 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader4 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader5 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader10 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader6 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader7 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader8 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader9 = new System.Windows.Forms.ColumnHeader();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.picImage = new System.Windows.Forms.PictureBox();
			this.pnlUnits = new System.Windows.Forms.Panel();
			this.pnlPatientSelect = new System.Windows.Forms.Panel();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.patientSelectTool1 = new gov.va.med.vbecs.GUI.controls.PatientSelectTool();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpTransfusionHistory.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.pnlUnits.SuspendLayout();
			this.pnlPatientSelect.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(692, 30);
			this.vbecsLogo1.Title = "Recent Transfusions/Issued Units";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// btnClose
			// 
			this.btnClose.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnClose.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnClose.Location = new System.Drawing.Point(612, 416);
			this.btnClose.Name = "btnClose";
			this.btnClose.TabIndex = 3;
			this.btnClose.Text = "&Close";
			this.btnClose.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// patientDisplayPanel2
			// 
			this.patientDisplayPanel2.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.patientDisplayPanel2.EnabledBloodAvailButton = false;
			this.patientDisplayPanel2.EnabledMedicationButton = false;
			this.patientDisplayPanel2.EnabledRecentOrdersButton = false;
			this.patientDisplayPanel2.EnabledRecentTransfusionsIssuesButton = false;
			this.patientDisplayPanel2.EnabledSIAndTRButton = false;
			this.patientDisplayPanel2.EnabledTransfusionReactionHistoryButton = false;
			this.patientDisplayPanel2.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.patientDisplayPanel2.Location = new System.Drawing.Point(4, 0);
			this.patientDisplayPanel2.Name = "patientDisplayPanel2";
			this.patientDisplayPanel2.Patient = null;
			this.patientDisplayPanel2.Size = new System.Drawing.Size(686, 44);
			this.patientDisplayPanel2.TabIndex = 0;
			// 
			// grpTransfusionHistory
			// 
			this.grpTransfusionHistory.AccessibleDescription = "Recently Transfused Issued Units";
			this.grpTransfusionHistory.AccessibleName = "Recently Transfused Issued Units";
			this.grpTransfusionHistory.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpTransfusionHistory.Controls.Add(this.lvTransfusionHistory);
			this.grpTransfusionHistory.Location = new System.Drawing.Point(48, 44);
			this.grpTransfusionHistory.Name = "grpTransfusionHistory";
			this.grpTransfusionHistory.Size = new System.Drawing.Size(640, 368);
			this.grpTransfusionHistory.TabIndex = 1;
			this.grpTransfusionHistory.TabStop = false;
			this.grpTransfusionHistory.Text = "Recently Transfused/Issued Units";
			// 
			// lvTransfusionHistory
			// 
			this.lvTransfusionHistory.AccessibleDescription = "Recently Transfused Issued Units";
			this.lvTransfusionHistory.AccessibleName = "Recently Transfused Issued Units";
			this.lvTransfusionHistory.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvTransfusionHistory.BackColor = System.Drawing.SystemColors.Control;
			this.lvTransfusionHistory.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																								   this.columnHeader1,
																								   this.columnHeader3,
																								   this.columnHeader2,
																								   this.columnHeader4,
																								   this.columnHeader5,
																								   this.columnHeader10,
																								   this.columnHeader6,
																								   this.columnHeader7,
																								   this.columnHeader8,
																								   this.columnHeader9});
			this.lvTransfusionHistory.FullRowSelect = true;
			this.lvTransfusionHistory.Location = new System.Drawing.Point(8, 16);
			this.lvTransfusionHistory.MultiSelect = false;
			this.lvTransfusionHistory.Name = "lvTransfusionHistory";
			this.lvTransfusionHistory.Size = new System.Drawing.Size(624, 344);
			this.lvTransfusionHistory.TabIndex = 2;
			this.lvTransfusionHistory.View = System.Windows.Forms.View.Details;
			this.lvTransfusionHistory.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvTransfusionHistory_ColumnClick);
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "Unit ID";
			this.columnHeader1.Width = 80;
			// 
			// columnHeader3
			// 
			this.columnHeader3.Text = "Product";
			this.columnHeader3.Width = 80;
			// 
			// columnHeader2
			// 
			this.columnHeader2.Text = "ABO/Rh";
			// 
			// columnHeader4
			// 
			this.columnHeader4.Text = "Expires";
			this.columnHeader4.Width = 80;
			// 
			// columnHeader5
			// 
			this.columnHeader5.Text = "Donation Type";
			this.columnHeader5.Width = 65;
			// 
			// columnHeader10
			// 
			this.columnHeader10.Text = "Status";
			// 
			// columnHeader6
			// 
			this.columnHeader6.Text = "Trx Complete";
			this.columnHeader6.Width = 80;
			// 
			// columnHeader7
			// 
			this.columnHeader7.Text = "Reaction";
			// 
			// columnHeader8
			// 
			this.columnHeader8.Text = "Division";
			this.columnHeader8.Width = 80;
			// 
			// columnHeader9
			// 
			this.columnHeader9.Text = "Comment";
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.picImage);
			this.grpImage.Location = new System.Drawing.Point(4, 44);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(40, 368);
			this.grpImage.TabIndex = 65;
			this.grpImage.TabStop = false;
			// 
			// picImage
			// 
			this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
			this.picImage.Location = new System.Drawing.Point(4, 12);
			this.picImage.Name = "picImage";
			this.picImage.Size = new System.Drawing.Size(32, 36);
			this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.picImage.TabIndex = 0;
			this.picImage.TabStop = false;
			// 
			// pnlUnits
			// 
			this.pnlUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlUnits.Controls.Add(this.grpImage);
			this.pnlUnits.Controls.Add(this.patientDisplayPanel2);
			this.pnlUnits.Controls.Add(this.btnClose);
			this.pnlUnits.Controls.Add(this.grpTransfusionHistory);
			this.pnlUnits.Location = new System.Drawing.Point(0, 32);
			this.pnlUnits.Name = "pnlUnits";
			this.pnlUnits.Size = new System.Drawing.Size(692, 440);
			this.pnlUnits.TabIndex = 67;
			// 
			// pnlPatientSelect
			// 
			this.pnlPatientSelect.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlPatientSelect.Controls.Add(this.btnOK);
			this.pnlPatientSelect.Controls.Add(this.patientSelectTool1);
			this.pnlPatientSelect.Controls.Add(this.btnCancel);
			this.pnlPatientSelect.Location = new System.Drawing.Point(0, 32);
			this.pnlPatientSelect.Name = "pnlPatientSelect";
			this.pnlPatientSelect.Size = new System.Drawing.Size(692, 440);
			this.pnlPatientSelect.TabIndex = 76;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(532, 416);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 11;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// patientSelectTool1
			// 
			this.patientSelectTool1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.patientSelectTool1.DisplaySIAndTRs = true;
			this.patientSelectTool1.EnabledBloodAvailButton = false;
			this.patientSelectTool1.EnabledMedicationButton = false;
			this.patientSelectTool1.EnabledRecentOrdersButton = false;
			this.patientSelectTool1.EnabledRecentTransfusionsIssuesButton = false;
			this.patientSelectTool1.EnabledSIAndTRButton = false;
			this.patientSelectTool1.EnabledTransfusionReactionHistoryButton = false;
			this.patientSelectTool1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.patientSelectTool1.Location = new System.Drawing.Point(4, 0);
			this.patientSelectTool1.Name = "patientSelectTool1";
			this.patientSelectTool1.SearchVistaLink = false;
			this.patientSelectTool1.Size = new System.Drawing.Size(684, 412);
			this.patientSelectTool1.TabIndex = 10;
			this.patientSelectTool1.PatientSelected += new System.EventHandler(this.patientSelectTool1_PatientSelected);
			this.patientSelectTool1.PatientDeselected += new System.EventHandler(this.patientSelectTool1_PatientDeselected);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnCancel.Location = new System.Drawing.Point(612, 416);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 12;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// DlgRecentTransfusionsIssues
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(692, 473);
			this.Controls.Add(this.pnlPatientSelect);
			this.Controls.Add(this.pnlUnits);
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(700, 500);
			this.Name = "DlgRecentTransfusionsIssues";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Recent Transfusions/Issued Units";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgRecentTransfusionsIssues_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.pnlUnits, 0);
			this.Controls.SetChildIndex(this.pnlPatientSelect, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpTransfusionHistory.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.pnlUnits.ResumeLayout(false);
			this.pnlPatientSelect.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Patient
		/// </summary>
		public BOL.Patient Patient
		{
			get
			{
				return this._patient;
			}
			set
			{
				this._patient = value;
				this.patientDisplayPanel2.Patient = value;
				//
				this.patientSelectTool1.EnabledRecentTransfusionsIssuesButton = false;
				this.patientDisplayPanel2.EnabledRecentTransfusionsIssuesButton = false;
			}
		}

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ",string.Empty);
			//
			
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC065.DlgRecentTransfusionsIssues());
			//
			this.SetThisToolTip(btnCancel,Common.StrRes.Tooltips.Common.Cancel());
			this.SetThisToolTip(btnClose,Common.StrRes.Tooltips.Common.ClickToDisregardChangesAndReturn());
			//
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectPatient().ResString);
			this.btnOK.EnabledButton = false;
			this.btnOK.Text = "&OK";
			//
			this.pnlPatientSelect.Visible = true;
			this.pnlUnits.Visible = false;
			//
			this.Patient = null;
			//
			this.patientSelectTool1.EnabledRecentTransfusionsIssuesButton = false;
			this.patientDisplayPanel2.EnabledRecentTransfusionsIssuesButton = false;
		}

		private void GetIssuedTransfusedUnits()
		{
			using (new WaitCursor())
			{
				if (this._patient != null)
				{
					_issuedTransfusedUnits = BOL.PatientTransfusion.GetRecentlyIssuedAndTransfusedUnitsForPatient(this._patient.PatientGuid);
				}
				else
				{
					_issuedTransfusedUnits = null;
				}
			}
		}

		private void LoadIssuedTransfusedUnits()
		{
			if ((_issuedTransfusedUnits == null) || (_issuedTransfusedUnits.Count==0))
			{
				this.lvTransfusionHistory.Items.Add(new ListViewItem(Common.StrRes.InfoMsg.UC065.NoRecentIssuedTransfusedUnits().ResString));
			}
			else
			{
				foreach(System.Data.DataRow unit in _issuedTransfusedUnits)
				{
					BOL.Division dvsn = new BOL.Division(unit[TABLE.VamcDivision.DivisionCode].ToString());
					ListViewItem lvi = new ListViewItem();
					lvi.Text = unit[TABLE.BloodUnit.EyeReadableUnitId].ToString();
					if (!unit.IsNull(ARTIFICIAL.PooledUnitsCount))
					{
						if (Convert.ToInt32(unit[ARTIFICIAL.PooledUnitsCount])>0)
						{
							unit[TABLE.BloodProduct.ProductShortName] = unit[TABLE.BloodProduct.ProductShortName].ToString()+" ("+unit[ARTIFICIAL.PooledUnitsCount].ToString()+")";
						}
					}
					lvi.SubItems.Add(unit[TABLE.BloodProduct.ProductShortName].ToString()+", "+BOL.BloodUnit.GetFullProductCode((Common.BarcodeType)Convert.ToChar(unit[TABLE.BloodUnit.LabelTypeCode]),unit[TABLE.BloodUnit.UnitProductCode].ToString(),Convert.ToChar(unit[TABLE.DonationType.DonationTypeCode]),unit[TABLE.BloodUnit.UnitDivisionId].ToString()));
					lvi.SubItems.Add(new BOL.AboRh(Common.Utility.GetAboFromString(unit[TABLE.BloodType.BloodTypeCode].ToString()),Common.Utility.GetRhFromString(unit[TABLE.RhFactor.RhFactorCode].ToString())).AboRHText);
					lvi.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(unit[TABLE.BloodUnitMedia.UnitExpirationDate]));
					lvi.SubItems.Add(unit[TABLE.DonationType.DonationTypeText].ToString());
					string status = unit[TABLE.UnitStatus.UnitStatusText].ToString();

					if (!unit.IsNull(TABLE.BloodUnitStatus.PresumedTransfusedIndicator))
					{
						if ((bool)unit[TABLE.BloodUnitStatus.PresumedTransfusedIndicator])
						{
							status = "Presumed "+status;
						}
					}

					lvi.SubItems.Add(status);
					if (unit.IsNull(TABLE.PatientTransfusion.TransfusionEndDateTime))
					{
						lvi.SubItems.Add(string.Empty);
					}
					else
					{
						lvi.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(unit[TABLE.PatientTransfusion.TransfusionEndDateTime]));
					}
					lvi.SubItems.Add(unit[TABLE.TransfusionReactionType.TransfusionReactionTypeText].ToString());
					lvi.SubItems.Add(dvsn.DivisionName);
					if (!unit.IsNull(TABLE.CannedComment.CannedCommentGuid))
					{
						lvi.SubItems.Add(BOL.CannedComment.CombinedComment((Guid)unit[TABLE.CannedComment.CannedCommentGuid],unit[TABLE.BloodUnitMedia.Comments].ToString()));
					}
					else
					{
						lvi.SubItems.Add(unit[TABLE.BloodUnitMedia.Comments].ToString());
					}
					this.lvTransfusionHistory.Items.Add(lvi);
				}
			}
			//
			controls.VbecsFunction.SetColumnWidths(this.lvTransfusionHistory);
		}

		private void patientSelectTool1_PatientDeselected(object sender, System.EventArgs e)
		{
			this.Patient = null;
			this._issuedTransfusedUnits = null;
			this.btnOK.EnabledButton = false;
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectPatient().ResString);
		}

		private void patientSelectTool1_PatientSelected(object sender, System.EventArgs e)
		{
			this.Patient = this.patientSelectTool1.SelectedPatient;
			this.GetIssuedTransfusedUnits();
			this.btnOK.EnabledButton = true;
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);

		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			if ((_issuedTransfusedUnits == null) || (_issuedTransfusedUnits.Count==0))
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC065.NoRecentIssuedTransfusedUnits());
				return;
			}
			this.pnlPatientSelect.Visible = false;
			this.pnlUnits.Visible = true;
			//
			this.LoadIssuedTransfusedUnits();

		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void lvTransfusionHistory_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if ((e.Column == 3)||(e.Column == 6))
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender,e,false,controls.ColumnClickSorter.ColumnSortType.DateTime);
			}
			else
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender,e,false,controls.ColumnClickSorter.ColumnSortType.String);
			}

		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgRecentTransfusionsIssues_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			//
			if (this.pnlPatientSelect.Visible && !this.btnOK.EnabledButton)
			{
				textToSpeak = this.btnOK.GetToolTip();
			}
			if(this.patientDisplayPanel2.Visible)
			{
				textToSpeak = this.patientDisplayPanel2.GetErrorMessagesFor508();
			}
			//
			this.SpeakMessage( textToSpeak );
		}
	}
}

